/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.input;

import de.willuhn.jameica.gui.dialogs.CalendarDialog;
import de.willuhn.jameica.gui.input.DialogInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import java.text.DateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;

public class DateInput
implements Input {
    private Map<String, Object> data = new HashMap<String, Object>();
    private static final Object PLACEHOLDER = new Object();
    private DateFormat format = DateUtil.DEFAULT_FORMAT;
    private DateTimeFormatter dtFormatter;
    private DateUtil.DatePositions datePositions;
    private DialogInput input = null;
    private CalendarDialog dialog = null;
    private String name = null;
    private Object oldValue = PLACEHOLDER;
    private boolean mandatory = false;

    public DateInput() {
        this(null);
    }

    public DateInput(Date date) {
        this(date, null);
    }

    public DateInput(Date date, DateFormat format) {
        if (format != null) {
            this.format = format;
        }
        this.dtFormatter = DateUtil.createDateTimeFormatter(this.format);
        this.datePositions = DateUtil.getDatePositions(this.dtFormatter);
        this.dialog = new MyCalendarDialog();
        if (date != null) {
            this.dialog.setDate(date);
        }
        this.dialog.setTitle(Application.getI18n().tr("Datum"));
        this.dialog.setText(Application.getI18n().tr("Bitte w\u00e4hlen Sie das Datum aus"));
        this.input = new DialogInput(date == null ? null : this.format.format(date), this.dialog);
        this.input.setData("datakey.tooltip", String.format(Application.getI18n().tr("DateInput.tooltip"), new Object[0]));
        this.setupDialogCloseListener();
        this.setupFocusListener();
        this.setupKeyListener();
    }

    private void setupDialogCloseListener() {
        this.dialog.addCloseListener(new Listener(){

            public void handleEvent(Event event) {
                if (event == null || event.data == null) {
                    return;
                }
                DateInput.this.input.setText(DateInput.this.format.format((Date)event.data));
            }
        });
    }

    private void setupFocusListener() {
        this.input.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                DateInput.this.parseAndUpdateInputText();
            }
        });
    }

    private void setupKeyListener() {
        this.input.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int selectionWidth;
                int selectionIndex;
                int monthOffset;
                int dayOffset;
                boolean minusPressed;
                boolean dayModifierPressed = e.stateMask == 65536;
                boolean monthModifierPressed = e.stateMask == 196608;
                boolean plusPressed = e.keyCode == 0x1000005;
                boolean bl = minusPressed = e.keyCode == 0x1000006;
                if (dayModifierPressed) {
                    dayOffset = plusPressed ? 1 : (minusPressed ? -1 : 0);
                    monthOffset = 0;
                    selectionIndex = DateInput.this.datePositions.dayIndex();
                    selectionWidth = DateInput.this.datePositions.dayWidth();
                } else if (monthModifierPressed) {
                    dayOffset = 0;
                    monthOffset = plusPressed ? 1 : (minusPressed ? -1 : 0);
                    selectionIndex = DateInput.this.datePositions.monthIndex();
                    selectionWidth = DateInput.this.datePositions.monthWidth();
                } else {
                    return;
                }
                if (dayOffset == 0 && monthOffset == 0) {
                    return;
                }
                DateInput.this.parseAndUpdateInputText().ifPresent(date -> {
                    LocalDate updatedDate = date.plusDays(dayOffset);
                    updatedDate = DateUtil.addMonthsMaintainingEndOfMonth(updatedDate, monthOffset);
                    DateInput.this.setValue(updatedDate);
                    DateInput.this.input.setSelection(selectionIndex, selectionIndex + selectionWidth);
                });
                e.doit = false;
            }
        });
    }

    @Override
    public void disable() {
        this.input.disable();
    }

    @Override
    public void enable() {
        this.input.enable();
    }

    @Override
    public void focus() {
        this.input.focus();
    }

    @Override
    public Control getControl() {
        return this.input.getControl();
    }

    @Override
    public Object getValue() {
        Optional<LocalDate> date = this.parseAndUpdateInputText();
        return date.map(d -> DateUtil.localDate2Date(d)).orElse(null);
    }

    private Optional<LocalDate> parseAndUpdateInputText() {
        String inputText = this.input.getText();
        if (inputText == null || inputText.isBlank()) {
            return Optional.empty();
        }
        Optional<LocalDate> date = DateUtil.parseUserInput(inputText, this.dtFormatter);
        if (date.isEmpty()) {
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Ung\u00fcltiges Datum: {0}", inputText), 1));
            return Optional.empty();
        }
        String parsedText = date.map(d -> d.format(this.dtFormatter)).orElse(inputText);
        if (!parsedText.equals(inputText)) {
            this.input.setText(parsedText);
        }
        return date;
    }

    @Override
    public boolean isEnabled() {
        return this.input.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.input.setEnabled(enabled);
    }

    public final void enableClientControl() {
        this.input.enableClientControl();
    }

    public final void disableClientControl() {
        this.input.disableClientControl();
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.input.setValue(null);
            this.input.setText("");
            return;
        }
        if (value instanceof String) {
            this.input.setText((String)value);
            try {
                this.format.parse((String)value);
            }
            catch (Exception e) {
                Logger.error((String)("invalid date " + value), (Throwable)e);
                Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Ung\u00fcltiges Datum: {0}", value.toString()), 1));
            }
            return;
        }
        if (value instanceof Date) {
            this.input.setText(this.format.format((Date)value));
        }
        if (value instanceof LocalDate) {
            this.input.setText(((LocalDate)value).format(this.dtFormatter));
        }
    }

    public void setText(String text) {
        this.dialog.setText(text);
    }

    public void setTitle(String title) {
        this.dialog.setTitle(title);
    }

    @Override
    public final void addListener(Listener l) {
        this.input.addListener(l);
    }

    @Override
    public final void paint(Composite parent) {
        this.input.setMandatory(this.isMandatory());
        this.input.paint(parent);
    }

    @Override
    public final void paint(Composite parent, int width) {
        this.input.setMandatory(this.isMandatory());
        this.input.paint(parent, width);
    }

    @Override
    public void setComment(String comment) {
        this.input.setComment(comment);
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory;
    }

    @Override
    public void setMandatory(boolean mandatory) {
        if (mandatory != this.mandatory && this.input != null) {
            this.mandatory = mandatory;
            this.input.setMandatory(this.mandatory);
            this.input.update();
        } else {
            this.input.setMandatory(this.mandatory);
            this.mandatory = mandatory;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        if (this.name != null) {
            Object o = this.getData("jameica.label");
            if (o == null || !(o instanceof Label)) {
                return;
            }
            Label label = (Label)o;
            if (label.isDisposed()) {
                return;
            }
            label.setText(this.name);
        }
    }

    @Override
    public boolean hasChanged() {
        String newValue = this.input.getText();
        try {
            if (this.oldValue == PLACEHOLDER || this.oldValue == newValue) {
                boolean bl = false;
                return bl;
            }
            boolean bl = newValue == null || !newValue.equals(this.oldValue);
            return bl;
        }
        finally {
            this.oldValue = newValue;
        }
    }

    @Override
    public void setData(String key, Object data) {
        this.data.put(key, data);
    }

    @Override
    public Object getData(String key) {
        return this.data.get(key);
    }

    private class MyCalendarDialog
    extends CalendarDialog {
        public MyCalendarDialog() {
            super(0);
        }

        @Override
        protected void paint(Composite parent) throws Exception {
            try {
                this.setDate((Date)DateInput.this.getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            super.paint(parent);
        }
    }
}

